unit Fifomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    BButStart: TBitBtn;
    BButStop: TBitBtn;
    BButExit: TBitBtn;
    CBFixedX: TCheckBox;
    Timer1: TTimer;
    procedure BButStartClick(Sender: TObject);
    procedure BButStopClick(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Timer1Timer(Sender: TObject);
  private
    DataCnt : double;
    XArg    : double;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  Step = 1.0;


(******************************************************************)
procedure TForm1.BButStartClick(Sender: TObject);
(******************************************************************)

begin
RChart1.ClearGraf;
RChart1.SetRange (1, 0, RChart1.Scale1Y.RangeLow, 100, RChart1.Scale1Y.RangeHigh);
DataCnt := 0;
XArg := 0;
BButExit.Enabled := false;
BButStart.Enabled := false;
BButStop.Enabled := true;
Timer1.Enabled := true;
CBFixedX.Enabled := false;
end;

(******************************************************************)
procedure TForm1.BButStopClick(Sender: TObject);
(******************************************************************)

begin
Timer1.Enabled := false;
BButExit.Enabled := true;
BButStart.Enabled := true;
BButStop.Enabled := false;
CBFixedX.Enabled := true;
end;


(******************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************)

begin
close;
end;

(******************************************************************)
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(******************************************************************)

begin
Screen.cursor := crDefault;
end;

(******************************************************************)
procedure TForm1.Timer1Timer(Sender: TObject);
(******************************************************************)

begin
if CBFixedX.Checked
  then begin        { non-scrolling x axis }
       RChart1.DataColor := clblue;
       RChart1.MarkAt (DataCnt, sin(0.19*XArg)*cos(0.02*XArg), 10);
       RChart1.DataColor := clred;
       RChart1.MoveTo (DataCnt-Step, cos(0.09*(XArg-Step)));
       RChart1.DrawTo (DataCnt, cos(0.09*XArg));
       if DataCnt > 80
         then begin
              RChart1.RemoveFirstItem;                  { remove MarkAt }
              RChart1.RemoveFirstItem;                  { remove MoveTo }
              RChart1.RemoveFirstItem;                  { remove DrawTo }
              RChart1.ScaleAllItems (1, -Step, 1, 0)
              end
         else dataCnt := dataCnt + step;
       end
  else begin        { scrolling x axis }
       RChart1.DataColor := clblue;
       RChart1.MarkAt (XArg, sin(0.19*XArg)*cos(0.02*XArg), 10);
       RChart1.DataColor := clred;
       RChart1.MoveTo (XArg-Step, cos(0.09*(XArg-Step)));
       RChart1.DrawTo (XArg, cos(0.09*XArg));
       if DataCnt > 80
         then begin
              RChart1.RemoveFirstItem;                  { remove MarkAt }
              RChart1.RemoveFirstItem;                  { remove MoveTo }
              RChart1.RemoveFirstItem;                  { remove DrawTo }
              RChart1.SetRange (1, RChart1.Scale1X.RangeLow+Step, RChart1.Scale1Y.RangeLow,
                                   RChart1.Scale1X.RangeHigh+Step, RChart1.Scale1Y.RangeHigh);
              end
         else dataCnt := dataCnt + Step;
       end;
XArg := XArg + step;
RChart1.ShowGraf;
end;

end.
