unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, ComCtrls, SDL_FolderTree,
  StdCtrls, SDL_NumIO, Buttons, SDL_Colsel, ExtCtrls; 


type
  TFrmMain = class(TForm)
    PnlDir: TPanel;
    Label2: TLabel;
    LblDir: TLabel;
    Panel1: TPanel;
    EdPath: TEdit;
    EdSubDir: TEdit;
    SButFindSelect: TSpeedButton;
    SButCreateFolder: TSpeedButton;
    Panel2: TPanel;
    SButRemoveFld: TSpeedButton;
    CBoxEnabled: TCheckBox;
    CBoxShowLines: TCheckBox;
    CBoxShowRoot: TCheckBox;
    CBoxSHowButs: TCheckBox;
    NIOIndent: TNumIO2;
    CBoxHotTrack: TCheckBox;
    ColSel: TColSel;
    CBoxOldDesign: TCheckBox;
    Panel3: TPanel;
    MMDirs: TMemo;
    Label1: TLabel;
    SbutReset: TSpeedButton;
    Label3: TLabel;
    FldTree: TFolderTree;
    procedure CBoxEnabledClick(Sender: TObject);
    procedure CBoxShowLinesClick(Sender: TObject);
    procedure CBoxShowRootClick(Sender: TObject);
    procedure CBoxSHowButsClick(Sender: TObject);
    procedure NIOIndentChange(Sender: TObject);
    procedure CBoxHotTrackClick(Sender: TObject);
    procedure SButRemoveFldClick(Sender: TObject);
    procedure SButCreateFolderClick(Sender: TObject);
    procedure SbutResetClick(Sender: TObject);
    procedure SButFindSelectClick(Sender: TObject);
    procedure ColSelChange(Sender: TObject);
    procedure CBoxOldDesignClick(Sender: TObject);
    procedure FldTreeDirChanged(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.dfm}

uses
  SDL_filesys;

(******************************************************************************)
procedure TFrmMain.CBoxEnabledClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.Enabled := CBoxEnabled.Checked;
end;

(******************************************************************************)
procedure TFrmMain.CBoxHotTrackClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.HotTrack := CBoxHotTrack.Checked;
end;

(******************************************************************************)
procedure TFrmMain.CBoxOldDesignClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.OldTreeStyle := CBoxOldDesign.Checked;
end;

(******************************************************************************)
procedure TFrmMain.CBoxSHowButsClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.ShowButtons := CBoxShowButs.Checked;
end;

(******************************************************************************)
procedure TFrmMain.CBoxShowLinesClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.ShowLines := CBoxShowLines.Checked;
end;

(******************************************************************************)
procedure TFrmMain.CBoxShowRootClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.ShowRoot := CBoxShowRoot.Checked;
end;

(******************************************************************************)
procedure TFrmMain.ColSelChange(Sender: TObject);
(******************************************************************************)

begin
FldTree.Color := ColSel.SelColor;
end;



(******************************************************************************)
procedure TFrmMain.NIOIndentChange(Sender: TObject);
(******************************************************************************)

begin
FldTree.Indent := NIOIndent.IntegerValue;
end;

(******************************************************************************)
procedure TFrmMain.SButCreateFolderClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.MakeSubFolder(EdSubDir.Text);
end;

(******************************************************************************)
procedure TFrmMain.SButFindSelectClick(Sender: TObject);
(******************************************************************************)

var
  SubDirs : TStringList;
  i       : integer;

begin
if not FldTree.SelectPath(EdPath.Text)
  then MessageDlg ('Path "'+EdPath.Text+'" does not exist', mtError, [mbOK], 0)
  else begin
       SubDirs := TStringList.Create;
       MMDirs.Clear;
       if FldTree.GetSubDirs(FldTree.Selected, SubDirs) then
         begin
         for i:=1 to SubDirs.Count do
           MMDirs.Lines.Add(SubDirs[i-1]);
         end;
       SubDirs.Free;
       end;
end;


(******************************************************************************)
procedure TFrmMain.SbutResetClick(Sender: TObject);
(******************************************************************************)

begin
FldTree.RefreshTree;
end;

(******************************************************************************)
procedure TFrmMain.SButRemoveFldClick(Sender: TObject);
(******************************************************************************)

begin
if MessageDlg ('Do you really want to delete the folder '+#13#10+'  '+FldTree.Directory+#13#10+'This action cannot be undone.', mtConfirmation,[mbYes, mbCancel], 0) = mrYes then
  begin
  if not FldTree.RemoveSelectedFolder then
    MessageDlg ('Folder could not be removed', mtInformation, [mbOK], 0);
  end;
end;

(******************************************************************************)
procedure TFrmMain.FldTreeDirChanged(Sender: TObject);
(******************************************************************************)

var
  SubDirs : TStringList;
  i       : integer;

begin
LblDir.Caption := FldTree.Directory;
SButRemoveFld.Enabled := true;
MMDirs.Clear;
SubDirs := TStringList.Create;
if FldTree.GetSubDirs(FldTree.Selected, SubDirs) then
  begin
  for i:=1 to SubDirs.Count do
    MMDirs.Lines.Add(SubDirs[i-1]);
  end;
SubDirs.Free;
end;



end.
